#ifndef CALCULIMAGE_H
#define CALCULIMAGE_H

#include <QtConcurrentRun>
#include <QtConcurrentMap>
#include <QThread>
#include <QFuture>
#include <QFutureWatcher>
#include <QImage>
#include <QColor>
#include <QDebug>
#include <math.h>

#include "generator/generator.h"
#include "fractals/fractal.h"
#include "accumulator/accumulator.h"

/*!
 *	\class CalculImage
 *	Cette classe permet de gnrer une image en fonction de paramtres de l'utilisateur
 *	Cette classe est un Thread pour pouvoir lanc la gnration sans bloqu la fentre
 *
 *	@see QThread
 */
class CalculImage : public QThread
{
	Q_OBJECT

	QImage _result;

	Generator * _gen;
	Fractal * _fractale;
	Accumulator * _accu;

	QFutureWatcher<void> * _watcher;

public:
	CalculImage(Generator * gen, Fractal * fractale, Accumulator * accu);
	virtual void run();
	QImage result();

private slots :
	void progress(int);

signals:
	void progressValueChanged(int value);
	void setRange(int min, int max);
};

#endif // CALCULIMAGE_H
