#include "colorator.h"

Colorator::Colorator(QObject *parent) :
    QObject(parent)
{
	_default = tr("Noir et blanc");
	addFunction(_default, new BWColor());
	addFunction(tr("Niveau de gris"), new GrayColor());
	addFunction(tr("Niveau de gris (2)"), new GrayV2Color());
	addFunction(tr("Niveau de gris invers (2)"), new GrayV2RevertColor());
	addFunction(tr("Color"), new ManyColor());
	addFunction(tr("Color (2)"), new ManyV2Color());
}

Colorator::~Colorator()
{
	qDeleteAll(_functions.values());
}

QPixmap Colorator::colorImage(FractalInfo * info, QString function )
{
	if( function == "")
		function = _default;

	ColorFunction * foo = _functions.value(function,NULL);
	if( foo == NULL )
		return QPixmap();
	else
		return foo->colorImage(info);
}

void Colorator::addFunction(QString name, ColorFunction * function)
{
	_functions.insert(name,function);
}
