#include "complex.h"

Complex::Complex(const float re, const float im) :
		_re(re),
		_im(im)
{
}

Complex& Complex::operator+=(const Complex& c)
{
	_re += c._re;
	_im += c._im;
	return *this;
}

Complex& Complex::operator-=(const Complex& c)
{
	_re -= c._re;
	_im -= c._im;
	return *this;
}

Complex& Complex::operator*=(const Complex& c)
{
	float tmp = _re;

	_re = _re * c._re - _im * c._im;
	_im = tmp * c._im + _im * c._re;

	return *this;
}

Complex& Complex::operator/=(const Complex& c)
{
	float tmpRe = _re;
	float tmp = c._re*c._re + c._im*c._im;
	_re = ( _re * c._re + _im   * c._im ) / tmp;
	_im = ( _im * c._re - tmpRe * c._im ) / tmp;

	return *this;
}

bool Complex::operator==(const Complex& c) const
{
	return ((_re == c._re) && (_im == c._im));
}

Complex Complex::operator+(const Complex& c) const
{
	return Complex(*this) += c;
}

Complex Complex::operator-(const Complex& c) const
{
	return Complex(*this) -= c;
}

Complex Complex::operator*(const Complex& c) const
{
	return Complex(*this) *= c;
}

Complex Complex::operator/(const Complex& c) const
{
	return Complex(*this) /= c;
}

float Complex::abs()
{
	return sqrt(_re*_re + _im*_im);
}

Complex operator+(const double x, const Complex& c)
{
	return (Complex(x) + c);
}

Complex operator-(const double x, const Complex& c)
{
	return (Complex(x) - c);
}

Complex operator*(const double x, const Complex& c)
{
	return (Complex(x) * c);
}

Complex operator/(const double x, const Complex& c)
{
	return (Complex(x) / c);
}
