#ifndef COMPLEX_H
#define COMPLEX_H

#include <math.h>

/*!
 *	\class Complex
 *	Classe reprsentant un complexe
 */
class Complex
{
	float _re;
	float _im;

public:
	Complex(const float re = 0.0, const float im = 0.0);

	inline float real() const { return _re; }
	inline float imag() const { return _im; }

	void setReal(float re) { _re = re;}
	void setImag(float im) { _im = im;}

	bool operator==(const Complex&) const;

	Complex& operator+=(const Complex&);
	Complex& operator-=(const Complex&);
	Complex& operator*=(const Complex&);
	Complex& operator/=(const Complex&);

	Complex operator+(const Complex&) const;
	Complex operator-(const Complex&) const;
	Complex operator*(const Complex&) const;
	Complex operator/(const Complex&) const;

	float abs();
};

Complex operator+(const double, const Complex&);
Complex operator-(const double, const Complex&);
Complex operator*(const double, const Complex&);
Complex operator/(const double, const Complex&);

#endif // COMPLEX_H
