#ifndef FRACTALBUILDER_H
#define FRACTALBUILDER_H

#include <QObject>
#include <QPointer>
#include <QThread>
#include <QtConcurrentMap>
#include <QFutureWatcher>

#include "accumulator/accumulatorfactory.h"
#include "generator/generatorfactory.h"
#include "fractals/fractalfactory.h"

/*!
 *	\class FractalBuilder
 *	Cette classe permet de gnrer une image en fonction de paramtres de l'utilisateur
 *	Cette classe est un Thread pour pouvoir lanc la gnration sans bloqu la fentre
 *
 *	@see QThread
 */
class FractalBuilder : public QThread
{
	Q_OBJECT

	FractalInfo * _info;

	QPointer<Accumulator> _accumulator;
	QPointer<Fractal> _fractal;
	QPointer<Generator> _generator;

	QFutureWatcher<void> * _watcher;

public:
	/// dfinit les informations de bases
	explicit FractalBuilder(QRectF fractaleSize, QSize imageSize, QObject *parent = 0);
	/// lance la cration
	virtual void run();

	void setAccumulator(QString name, bool autoParam);
	void setFractal(QString name, int limit, bool autoParam);
	void setGenerator(QString name, bool autoParam);

	FractalInfo * info() { return _info; }

private slots :
	void progress(int);

signals:
	void progressValueChanged(int value);
	void setRange(int min, int max);

//factory part - pour dfinir des fractales par dfauts
private:
	static QStringList _definedFractalNames;
public:
	static QStringList definedFractalNames();
	static FractalBuilder * build(QString name, QSize size, QObject * parent);
};

#endif // FRACTALBUILDER_H
