#include "fractalinfo.h"

FractalInfo::FractalInfo(QRectF fractaleSize, QSize imageSize, QObject *parent) :
	QObject(parent),
	_fractaleSize(QRectF(fractaleSize)),
	_imageSize(QSize(imageSize)),
	_data(imageSize.width()*imageSize.height())
{
	_max = 0;
	_mutex = new QMutex();
}

FractalInfo::~FractalInfo()
{
	delete _mutex;
}

void FractalInfo::changeParameters(QRectF fractaleSize, QSize imageSize)
{
	QMutexLocker lock(_mutex);
	_max = 0;

	_fractaleSize = QRectF(fractaleSize);
	_imageSize = QSize(imageSize);
	_data.resize(imageSize.width()*imageSize.height());
	for(int i = 0; i < _data.size(); i++)
		_data[i] = 0;
}

unsigned int FractalInfo::pixel(int x, int y)
{
	QMutexLocker lock(_mutex);

	return _data[index(x,y)];
}

void FractalInfo::setPixel(int x, int y, unsigned int value)
{
	QMutexLocker lock(_mutex);

	_max = qMax(_max, value);
	_data[index(x,y)] = value;
}

void FractalInfo::incrPixel(int x, int y)
{
	QMutexLocker lock(_mutex);

	_data[index(x,y)]++;
	_max = qMax(_max, _data[index(x,y)]);
}

void FractalInfo::incrPixel(int x, int y, unsigned int value)
{
	QMutexLocker lock(_mutex);

	_data[index(x,y)] += value;
	_max = qMax(_max, _data[index(x,y)]);
}

void FractalInfo::clear()
{
	QMutexLocker lock(_mutex);

	_max = 0;
	for(int i = 0; i < _data.size(); i++)
		_data[i] = 0;
}
