#ifndef FRACTALEINFO_H
#define FRACTALEINFO_H

#include <QObject>
#include <QRectF>
#include <QSize>
#include <QVarLengthArray>
#include <QImage>
#include <QColor>
#include <QDebug>
#include <QMutex>

/*!
 *	\class FractalInfo
 *	Cette classe contient les informations d'une fractale
 *	Les informations sont :
 *		@li La taille d'entre
 *		@li La taille de sortie
 *		@li Les donnes calcules
 *
 *	Les donnes sont protges par un Mutex pour viter les problmes de concurrences
 *	@see QObject
 */
class FractalInfo : public QObject
{
	QRectF _fractaleSize;
	QSize _imageSize;
	QVarLengthArray<unsigned int> _data;
	QMutex * _mutex;

	unsigned int _max;

public:
	/// dfinit les paramtres de bases d'une image fractale
	FractalInfo(QRectF fractaleSize, QSize imageSize, QObject *parent = 0);
	virtual ~FractalInfo();

	void changeParameters(QRectF fractaleSize, QSize imageSize);

	inline QRectF & fractaleSize() { return _fractaleSize; }
	inline QSize & imageSize() { return _imageSize; }
	inline unsigned int max() { return (_max==0)?1:_max; }

	/// rcupre la valeur du pixel aux coordonnes (x,y)
	unsigned int pixel(int x, int y);
	/// modifie la valeur du pixel
	void setPixel(int x, int y, unsigned int value);
	/// incrmente la valeur d'un pixel
	void incrPixel(int x, int y);
	/// incrmente la valeur d'un pixel de la valeur "value"
	void incrPixel(int x, int y, unsigned int value);

	/// vide les donnes
	void clear();

private:
	inline int index(int x, int y) { return x*_imageSize.height() + y; }
};

#endif // FRACTALEINFO_H
