#include "boat.h"

Boat::Boat(int limit, QObject * parent):
		Fractal(limit,parent)
{
}

void Boat::genererSequence(const Complex &pInit, QVector<Complex> & sequence)
{
	sequence.clear();

	Complex z = Complex();

	while( ! fin(z) ) {
		z = suivant(z,pInit);
		sequence << z;

		if( sequence.size() > limit() ) {
			sequence.clear();
			return;
		}
	}
}

Complex Boat::suivant(const Complex & Zn, const Complex & c)
{
	Complex Znt = Complex(qAbs(Zn.real()), qAbs(Zn.imag()));
	return Znt * Znt + c;
}

bool Boat::fin(const Complex & Zn)
{
	return Zn.real() * Zn.real() + Zn.imag() * Zn.imag() > 4;
}
