#ifndef FRACTALE_H
#define FRACTALE_H

#include <QObject>
#include <QPointF>
#include <QVector>
#include <QMutex>
#include <QMutexLocker>
#include "../complex.h"

/*!
 *	\class Fractal
 *	Interface dfinissant une fractale
 *	Cette classe permet de generer les points d'une fractale
 */
class Fractal : public QObject
{
	int _limit;

public:
	/*!
	 *	limit permet de fixer la valeur de dpassement de la fractale
	 *	plus la valeur est lev et plus la courbe est prcise et le temps de calcul important
	 */
	Fractal(int limit = 1000, QObject *parent = 0);
	/// genere une sequence en fonction d'un point initial et remplit le QVector
	virtual void genererSequence(const Complex &pInit, QVector<Complex> & sequence) = 0;
	/// retourne la valeur limit
	inline int limit() { return _limit; }
};

#endif // FRACTALE_H
