#include "fractalfactory.h"

FractalFactory::FractalFactory(QObject *parent) :
    QObject(parent)
{
	_fractaleNames << tr("Bateau en feu") << tr("Julian")
			<< tr("Mandelbrot") << tr("Newton") << tr("Nova")
			<< tr("Tri-corne");
}

FractalFactory * FractalFactory::_instance = NULL;

FractalFactory * FractalFactory::instance(QObject * parent)
{
	if( _instance == NULL )
		_instance = new FractalFactory(parent);

	return _instance;
}

Fractal * FractalFactory::fractal(QString name, int limit, bool autoParam)
{
	if( _fractaleNames[0] == name )
		return new Boat(limit, parent());

	if( _fractaleNames[1] == name ) {
		if( autoParam )
			return new Julian(Complex(), limit, parent());
		else
			return new Julian(limit, parent());
	}

	if( _fractaleNames[2] == name ) {
		if( autoParam )
			return new Mandelbrot(Complex(), limit, parent());
		else
			return new Mandelbrot(limit, parent());
	}

	if( _fractaleNames[3] == name )
		return new Newton(limit, parent());

	if( _fractaleNames[4] == name )
		return new Nova(limit, parent());

	if( _fractaleNames[5] == name )
		return new Tricorn(limit, parent());

	qCritical() << "Unknow fractale : " << name;
	return NULL;
}
