#ifndef FRACTALEFACTORY_H
#define FRACTALEFACTORY_H

#include <QObject>
#include <QStringList>
#include <QDebug>

#include "fractal.h"

#include "mandelbrot.h"
#include "nova.h"
#include "boat.h"
#include "tricorn.h"
#include "julian.h"
#include "newton.h"
#include <QInputDialog>

/*!
 *	\class FractalFactory
 *	Ce singleton permet de crer de faon simple une fractale
 *	@see QObject
 */

class FractalFactory : public QObject
{
//singleton part
	static FractalFactory * _instance;
public:
	/// recupre l'instance de la factory
	static FractalFactory * instance(QObject * parent = 0);

//factory
private:
	QStringList _fractaleNames;
	//bloque l'instanciation
	explicit FractalFactory(QObject *parent = 0);

public:
	/// retourne les noms des diffrents accumulateurs
	QStringList names() { return _fractaleNames; }
	/*!
	 *	cr une fractale  partir de son nom
	 *	fixe la limit
	 *	affiche une fenetre de config si autoParam est mis a false
	 */
	Fractal * fractal(QString name, int limit, bool autoParam = true);
};

#endif // FRACTALEFACTORY_H
