#include "julian.h"

Julian::Julian(Complex pInit, int limit, QObject * parent):
		Fractal(limit,parent),
		_c(pInit)
{
}

Julian::Julian(int limit, QObject * parent):
		Fractal(limit,parent)
{
	double reel = QInputDialog::getDouble(0,tr("Paramtre"),
										  tr("Valeur de le partie relle"),
										  0,-100000,+100000,
										  8);

	double imag = QInputDialog::getDouble(0,tr("Paramtre"),
										  tr("Valeur de le partie imaginaire"),
										  0,-100000,+100000,
										  8);

	_c = Complex(reel, imag);
}


void Julian::genererSequence(const Complex &pInit, QVector<Complex> & sequence)
{
	sequence.clear();

	Complex z = pInit;

	while( ! fin(z) ) {
		z = suivant(z);
		sequence << z;

		if( sequence.size() > limit() ) {
			sequence.clear();
			return;
		}
	}
}

Complex Julian::suivant(const Complex & Zn)
{
	return Zn * Zn + _c;
}

bool Julian::fin(const Complex & Zn)
{
	return Zn.real() * Zn.real() + Zn.imag() * Zn.imag() > 4;
}
