#ifndef JULIAN_H
#define JULIAN_H

#include "fractal.h"

#include <QInputDialog>

/*!
 *	\class Julian
 *	Cette classe reprsente la fractale Julian
 *	@see Fractal
 */
class Julian : public Fractal
{
	Complex _c;

public:
	/// \sa Fractal
	Julian(Complex pInit = Complex(), int limit = 1000, QObject * parent = 0);
	/// \sa Fractal
	Julian(int limit = 1000, QObject * parent = 0);
	/// \sa Fractal::genererSequence()
	virtual void genererSequence(const Complex &pInit, QVector<Complex> & sequence);

private:
	virtual Complex suivant(const Complex & Zn);
	virtual bool fin(const Complex & Zn);
};

#endif // JULIAN_H
