#include "mandelbrot.h"

Mandelbrot::Mandelbrot(Complex first, int limit, QObject * parent) :
		Fractal(limit,parent),
		_first(first)
{
}

Mandelbrot::Mandelbrot(int limit, QObject * parent) :
		Fractal(limit,parent)
{
	double reel = QInputDialog::getDouble(0,tr("Paramtre"),
										  tr("Valeur de le partie relle"),
										  0,-100000,+100000,
										  8);

	double imag = QInputDialog::getDouble(0,tr("Paramtre"),
										  tr("Valeur de le partie imaginaire"),
										  0,-100000,+100000,
										  8);

	_first = Complex(reel, imag);
}

void Mandelbrot::genererSequence(const Complex &pInit, QVector<Complex> & sequence)
{
	sequence.clear();

	Complex z = _first;

	while( ! fin(z) ) {
		z = suivant(z,pInit);
		sequence << z;

		if( sequence.size() > limit() ) {
			sequence.clear();
			return;
		}
	}
}

Complex Mandelbrot::suivant(Complex & Zn, const Complex & c)
{
	return Zn * Zn + c;
}

bool Mandelbrot::fin(Complex & Zn)
{
	return Zn.real() * Zn.real() + Zn.imag() * Zn.imag() > 2;
}
