#ifndef MANDELBROT_H
#define MANDELBROT_H

#include "fractal.h"

#include <QInputDialog>

/*!
 *	\class Mandelbrot
 *	Cette classe reprsente la fractale Mandelbrot
 *	@see Fractal
 */
class Mandelbrot : public Fractal
{
	Complex _first;

public:
	/// \sa Fractal
	Mandelbrot(Complex first = Complex(), int limit = 1000, QObject * parent = 0);
	/// \sa Fractal
	Mandelbrot(int limit = 1000, QObject * parent = 0);
	/// \sa Fractal::genererSequence()
	virtual void genererSequence(const Complex &pInit, QVector<Complex> & sequence);

private:
	virtual Complex suivant(Complex & Zn, const Complex & c);
	virtual bool fin(Complex & Zn);
};

#endif // MANDELBROT_H
