#include "newton.h"

Newton::Newton(int limit, QObject * parent):
		Fractal(limit,parent)
{
}

void Newton::genererSequence(const Complex &pInit, QVector<Complex> & sequence)
{
	sequence.clear();

	Complex z = pInit;

	while( ! fin(z) ) {
		z = suivant(z);
		sequence << z;

		if( sequence.size() > limit() ) {
			sequence.clear();
			return;
		}
	}
}

Complex Newton::suivant(const Complex & Zn)
{
	return Zn - (Zn * Zn * Zn - 1.) / (3. * Zn * Zn );
}

bool Newton::fin(const Complex & Zn)
{
	return (Zn * Zn * Zn - 1.).abs() < 0.01;
}
