#include "nova.h"

Nova::Nova(int limit, QObject * parent) :
		Fractal(limit,parent)
{
}

void Nova::genererSequence(const Complex &pInit, QVector<Complex> & sequence)
{
	sequence.clear();

	Complex z = Complex(1.);
	Complex old = Complex();

	while( ! fin(z,old) ) {
		old = z;
		z = suivant(z,pInit);
		sequence << z;

		if( sequence.size() > limit() ) {
			sequence.clear();
			return;
		}
	}
}

Complex Nova::suivant(const Complex & Zn, const Complex & c)
{
	return Zn - 2. * (Zn * Zn * Zn - 1.) / (3. * Zn * Zn ) + c;
}

bool Nova::fin(const Complex & Zn, const Complex & old)
{
	return (Zn - old).abs() < 0.05;
}
