#include "tricorn.h"

Tricorn::Tricorn(int limit, QObject * parent):
		Fractal(limit,parent)
{
}

void Tricorn::genererSequence(const Complex &pInit, QVector<Complex> & sequence)
{
	sequence.clear();

	Complex z = Complex();

	while( ! fin(z) ) {
		z = suivant(z,pInit);
		sequence << z;

		if( sequence.size() > limit() ) {
			sequence.clear();
			return;
		}
	}
}

Complex Tricorn::suivant(const Complex & Zn, const Complex & c)
{
	Complex Znt = Complex(-Zn.real(), Zn.imag());
	return Znt * Znt + c;
}

bool Tricorn::fin(const Complex & Zn)
{
	return Zn.real() * Zn.real() + Zn.imag() * Zn.imag() > 4;
}
