#ifndef TRICORN_H
#define TRICORN_H

#include "fractal.h"

/*!
 *	\class Tricorn
 *	Cette classe reprsente la fractale Tricorn
 *	@see Fractal
 */
class Tricorn : public Fractal
{
public:
	/// \sa Fractal
	Tricorn(int limit = 1000, QObject * parent = 0);
	/// \sa Fractal::genererSequence()
	virtual void genererSequence(const Complex &pInit, QVector<Complex> & sequence);

private:
	virtual Complex suivant(const Complex & Zn, const Complex & c);
	virtual bool fin(const Complex & Zn);
};

#endif // TRICORN_H
