#ifndef GENERATOR_H
#define GENERATOR_H

#include <QObject>
#include <QPointF>
#include <QRectF>

#include "../complex.h"
#include "../fractalinfo.h"

/*!
 *	\class Generator
 *	Cette interface reprsente un gnrateur de points
 *	genere des points en fonction des informations passes au constructeur
 *
 *	@see QObject
 */
class Generator : public QObject
{
	Q_OBJECT

	FractalInfo * _info;

public:
	/// le FractalInfo permet de calculer les points  gnrer
	Generator(FractalInfo * info, QObject * parent = NULL);

	/// calcul le point suivant - retourne false quand il n'y a plus de point.
	virtual bool next() = 0;
	/// retourne le point calcul par la fonction next()
	virtual const Complex getPoint() = 0;
	/// retourne l'information fournit par le constructeur
	inline FractalInfo * info() { return _info; }
};

#endif // GENERATOR_H
