#include "generatorfactory.h"

GeneratorFactory::GeneratorFactory(QObject *parent) :
	QObject(parent)
{
	_generatorNames << tr("Gnration alatoire") << tr("Gnration par l'image");
}

GeneratorFactory * GeneratorFactory::_instance = NULL;

GeneratorFactory * GeneratorFactory::instance(QObject * parent)
{
	if( _instance == NULL )
		_instance = new GeneratorFactory(parent);

	return _instance;
}

Generator * GeneratorFactory::generator(QString name, FractalInfo * info, bool autoParam)
{
	if( _generatorNames[0] == name ) {
		if( autoParam )
			return new RandomPointGenerator(1*1000000, info, parent());
		else
			return new RandomPointGenerator(info, parent());
	}

	if( _generatorNames[1] == name )
		return new ImageGenerator(info, parent());

	qCritical() << "Unknow generator : " << name;
	return NULL;
}
