#ifndef GENERATORFACTORY_H
#define GENERATORFACTORY_H

#include <QObject>
#include <QStringList>

#include "generator.h"
#include "randompointgenerator.h"
#include "imagegenerator.h"

/*!
 *	\class GeneratorFactory
 *	Cette factory permet de crer des generateurs de points
 *
 *	@see QObject
 */
class GeneratorFactory : public QObject
{
//singleton part
	static GeneratorFactory * _instance;
public:
	/// recupre l'instance de la factory
	static GeneratorFactory * instance(QObject * parent = 0);

//factory
private:
	QStringList _generatorNames;
	//bloque l'instanciation
	explicit GeneratorFactory(QObject *parent = 0);

public:
	/// retourne les noms des diffrents accumulateurs
	QStringList names() { return _generatorNames; }
	/*!
	 *	cr un generateur  partir de son nom
	 *	dfinit les informations de la fractale par le FractalInfo
	 *	affiche une fenetre de config si autoParam est mis a false
	 */
	Generator * generator(QString name, FractalInfo * info, bool autoParam = true);
};

#endif // GENERATORFACTORY_H
