#include "imagegenerator.h"

ImageGenerator::ImageGenerator(FractalInfo * info, QObject * parent) :
		Generator(info,parent)
{
	_current = QPoint();
}

bool ImageGenerator::next()
{
	if( _current.x() >= info()->imageSize().height() )
		return false;

	QRectF zone = info()->fractaleSize();

	_point = Complex(
				zone.x() + zone.width() * (_current.y() + .5) / (info()->imageSize().width() - 1),
				zone.y() + zone.height() * (_current.x() + .5) / (info()->imageSize().height() - 1)
				);

	_current.ry()++;

	if( _current.y() >= info()->imageSize().width())
		_current = QPoint(_current.x()+1,0);

	return true;
}

const Complex ImageGenerator::getPoint()
{
	return _point;
}
