#include "randompointgenerator.h"

RandomPointGenerator::RandomPointGenerator(unsigned int nbPoint, FractalInfo * info, QObject * parent) :
		Generator(info,parent),
		_nbPointMax(nbPoint),
		_nbPoint(0)
{
	qsrand(QDateTime::currentDateTime().toTime_t());
}

RandomPointGenerator::RandomPointGenerator(FractalInfo * info, QObject * parent) :
		Generator(info,parent)
{
	_nbPoint = 0;
	double value = QInputDialog::getDouble( 0,
										tr("Paramtre du gnrateur"),
										tr("Nombre de point alatoire (en million)"),
										0,
										0,
										1000.0
										);

	_nbPointMax = value * 1000000;
}

bool RandomPointGenerator::next()
{
	++_nbPoint;

	if( _nbPoint == _nbPointMax )
		return false;

	double x = qrand()/(double)RAND_MAX;
	double y = qrand()/(double)RAND_MAX;

	point.setReal(
				info()->fractaleSize().x() -
				( info()->fractaleSize().width() - info()->fractaleSize().width() ) +
				x * info()->fractaleSize().width()
			);

	point.setImag(
				info()->fractaleSize().y() -
				( info()->fractaleSize().height() - info()->fractaleSize().width() ) +
				y * info()->fractaleSize().height()
			);

	return true;
}

const Complex RandomPointGenerator::getPoint()
{
	return point;
}
