#ifndef RANDOMPOINTGENERATOR_H
#define RANDOMPOINTGENERATOR_H

#include <cstdlib>

#include <QSize>
#include <QDateTime>
#include <QRectF>
#include <QInputDialog>

#include "generator.h"

/*!
 *	\class RandomPointGenerator
 *	Cette classe permet de gnrer des points
 *	Les points gnrs sont pris alatoirement sur la zone de l'image de sortie
 *
 *	@see Generator
 */

class RandomPointGenerator : public Generator
{
	unsigned int _nbPointMax;
	unsigned int _nbPoint;
	Complex point;

public:
	/// fixe le nombre de points a calculer par nbPoint \sa Generator
	RandomPointGenerator(unsigned int nbPoint, FractalInfo * info, QObject * parent);
	/// affiche une fenetre pour demander a l'utilisateur le nombre de points \sa Generator
	RandomPointGenerator(FractalInfo * info, QObject * parent);
	/// \sa Generator::next()
	virtual bool next();
	/// \sa Generator::getPoint()
	virtual const Complex getPoint();
};

#endif // RANDOMPOINTGENERATOR_H
