#include "mainwindow.h"
#include "ui_mainwindow.h"

MainWindow::MainWindow(QWidget *parent) :
		QMainWindow(parent),
		ui(new Ui::MainWindow)
{
	ui->setupUi(this);

	_tabCounter = 1;
	_stop = tr("Stop");
	_drawHere = tr("Dessiner ici");

	ui->pb_drawImage->setText(_drawHere);

	_preview = new QTimer(this);
	_preview->setInterval(2000);
	connect(_preview, SIGNAL(timeout()), this, SLOT(drawTempImage()) );

	ui->cb_coloration->addItems(Colorator().functionList());
	connect(ui->cb_coloration, SIGNAL(currentIndexChanged(int)), SLOT(drawTempImage()));

	ui->cb_choice_gen->addItems(GeneratorFactory::instance(this)->names());
	ui->cb_choice_fract->addItems(FractalFactory::instance(this)->names());
	ui->cb_choice_accu->addItems(AccumulatorFactory::instance(this)->names());

	ui->cb_choice_defined->addItems(FractalBuilder::definedFractalNames());
}

MainWindow::~MainWindow()
{
	delete ui;
}

void MainWindow::changeEvent(QEvent *e)
{
	QMainWindow::changeEvent(e);
	switch (e->type()) {
 case QEvent::LanguageChange:
		ui->retranslateUi(this);
		break;
 default:
		break;
	}
}

void MainWindow::drawImage()
{
	FractalInfo * info = _currentBuilder->info();
	QPixmap image( Colorator().colorImage(info,ui->cb_coloration->currentText()));
	ui->label->setPixmap(image);

	ui->progressBar->setDisabled(true);
	ui->pb_drawImage->setEnabled(true);

	ui->statusBar->showMessage(QString(tr("Time elapsed : %1 s")).arg(_counter.elapsed()/1000.0,0,'g',3));

	ui->pb_drawImage->setText(_drawHere);
	ui->gb_info->setEnabled(true);
	ui->pb_new_tab->setEnabled(true);
}

void MainWindow::drawTempImage()
{
	if( _currentBuilder.isNull() )
		return;

	QPixmap image(Colorator().colorImage(_currentBuilder->info(),ui->cb_coloration->currentText()));
	ui->label->setPixmap(image);
}

void MainWindow::updateInfo()
{
	FractalInfo * info = _currentBuilder->info();
	ui->dsb_complex_x->setValue(info->fractaleSize().x());
	ui->dsb_complex_y->setValue(info->fractaleSize().y());
	ui->dsb_complex_width->setValue(info->fractaleSize().width());
	ui->dsb_complex_height->setValue(info->fractaleSize().height());

	ui->sb_image_width->setValue(info->imageSize().width());
	ui->sb_image_height->setValue(info->imageSize().height());
}

void MainWindow::initDefinedBuilder()
{
	if( _currentBuilder.isNull() )
		delete _currentBuilder;

	QString name = ui->cb_choice_defined->currentText();
	_currentBuilder = FractalBuilder::build(
			name,QSize(ui->sb_image_width->value(),ui->sb_image_height->value()),this
			);

	updateInfo();
}

void MainWindow::initCustomBuilder()
{
	QRectF fractalSize( ui->dsb_complex_x->value(),
						ui->dsb_complex_y->value(),
						ui->dsb_complex_width->value(),
						ui->dsb_complex_height->value());

	QSize imageSize(ui->sb_image_width->value(),					ui->sb_image_height->value());

	if( _currentBuilder.isNull() )
		_currentBuilder = new FractalBuilder(fractalSize,imageSize,this);
	else
		_currentBuilder->info()->changeParameters(fractalSize,imageSize);

	bool autoParam = ui->cb_autoParam->isChecked();
	int limit = ui->sb_limit->value();

	_currentBuilder->setGenerator(ui->cb_choice_gen->currentText(),autoParam);
	_currentBuilder->setFractal(ui->cb_choice_fract->currentText(),limit,autoParam);
	_currentBuilder->setAccumulator(ui->cb_choice_accu->currentText(),autoParam);
}

void MainWindow::on_pb_drawImage_clicked()
{
	if( ui->pb_drawImage->text() == _stop ) {
		_currentBuilder->terminate();
		ui->pb_drawImage->setText(_drawHere);
		return;
	}

	if( ui->gb_fract_defined->isChecked() )
		initDefinedBuilder();
	else
		initCustomBuilder();

	connect(_currentBuilder, SIGNAL(finished()), _preview, SLOT(stop()) );
	connect(_currentBuilder, SIGNAL(finished()), this, SLOT(drawImage()) );
	connect(_currentBuilder, SIGNAL(progressValueChanged(int)),ui->progressBar,SLOT(setValue(int)));
	connect(_currentBuilder, SIGNAL(setRange(int,int)),ui->progressBar,SLOT(setRange(int,int)));

	if( ui->cb_preview->isChecked() )
		_preview->start();

	_counter = QTime::currentTime();
	ui->progressBar->setEnabled(true);
	ui->gb_info->setEnabled(false);

	_currentBuilder->start();

	ui->pb_drawImage->setText(_stop);
	ui->pb_new_tab->setDisabled(true);
}

void MainWindow::on_gb_fract_defined_toggled(bool checked)
{
	ui->gb_info->setDisabled(checked);
	ui->gb_frac_create->setChecked(!checked);
}

void MainWindow::on_gb_frac_create_clicked(bool checked)
{
	ui->gb_fract_defined->setChecked(!checked);
}

void MainWindow::on_pb_new_tab_clicked()
{
	QLabel * label = new QLabel();
	label->setPixmap(*(ui->label->pixmap()));
	label->setObjectName("imageDisplayer");

	QScrollArea * scrollArea = new QScrollArea;
	scrollArea->setWidget(label);
	scrollArea->setObjectName("scrollArea");

	QPushButton * pb_export = new QPushButton(tr("Export de l'image"));
	QPushButton * pb_close = new QPushButton(tr("Fermer l'onglet"));

	QHBoxLayout * buttonLayout = new QHBoxLayout;
	buttonLayout->addStretch();
	buttonLayout->addWidget(pb_export);
	buttonLayout->addWidget(pb_close);

	QVBoxLayout * mainLayout = new QVBoxLayout;
	mainLayout->addWidget(scrollArea);
	mainLayout->addLayout(buttonLayout);

	QWidget * mainWidget = new QWidget(this);
	mainWidget->setLayout(mainLayout);

	ui->tabWidget->addTab(mainWidget, QString(tr("Fractale N%1")).arg(_tabCounter));
	_tabCounter++;

	connect(pb_close,SIGNAL(clicked()), SLOT(closeTab()));
	connect(pb_export,SIGNAL(clicked()), SLOT(exportImage()));
}

void MainWindow::closeTab()
{
	int index = ui->tabWidget->currentIndex();
	ui->tabWidget->removeTab(index);
}

void MainWindow::exportImage()
{
	int index = ui->tabWidget->currentIndex();
	QWidget * scrollArea = ui->tabWidget->widget(index)->findChild<QWidget*>("scrollArea");
	if( scrollArea ) {
		QLabel * label = scrollArea->findChild<QLabel*>("imageDisplayer");
		QString file = QFileDialog::getSaveFileName(this,
													tr("Save File"),
													"./",
													tr("Images (*.png)"));
		if( !file.isEmpty() && label != NULL )
			label->pixmap()->save(file,"PNG");
	}
}
