#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QtDebug>
#include <QThreadPool>
#include <QTimer>
#include <QPointer>
#include <QFileDialog>

#include "fractal/fractalbuilder.h"

#include "fractal/colorator.h"

namespace Ui {
	class MainWindow;
}

/*!
 *	\class MainWindow
 *	Cette classe est la fentre principale
 *
 *	@see QMainWindow
 */
class MainWindow : public QMainWindow {
	Q_OBJECT

public:
	MainWindow(QWidget *parent = 0);
	~MainWindow();

protected:
	void changeEvent(QEvent *e);

private:
	void initCustomBuilder();
	void initDefinedBuilder();

private slots:
	void on_gb_frac_create_clicked(bool checked);
	void on_gb_fract_defined_toggled(bool );
	void on_pb_drawImage_clicked();
	void on_pb_new_tab_clicked();

	void drawTempImage();
	void drawImage();
	void updateInfo();

	void exportImage();
	void closeTab();

private:
	QPointer<FractalBuilder> _currentBuilder;
	QTimer * _preview;
	QTime _counter;
	int _tabCounter;

	QString _drawHere;
	QString _stop;

	Ui::MainWindow *ui;
};

#endif // MAINWINDOW_H
