/****************************************************************************
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor,
** Boston, MA  02110-1301, USA.
**
** ---
** Copyright (C) 2006, Nicolas Arnaud-Cormos <nicolas@qtfr.org>
**
****************************************************************************/

#include <QtGui>

#include "window.h"
#include "operationmanager.h"

Window::Window( QWidget * parent, Qt::WFlags f ) :
    QWidget(parent, f)
{
    setupUi(this);
    connect( m_operation, SIGNAL( activated( const QString & ) ),
            this, SLOT( slotChangeOperation( const QString & ) ) );
    connect( m_var1, SIGNAL( textChanged ( const QString & ) ),
             this, SLOT( slotCalculate() ) );
    connect( m_var2, SIGNAL( textChanged ( const QString & ) ),
             this, SLOT( slotCalculate() ) );
    connect( m_var3, SIGNAL( textChanged ( const QString & ) ),
             this, SLOT( slotCalculate() ) );

    // Initialisation
    m_operation->addItems( OperationManager::instance()->operationList() );
    m_operation->setCurrentIndex(0);
}


void Window::slotChangeOperation( const QString & text )
{
    int num = OperationManager::instance()->numVariable(text);
    m_var1->setEnabled( num >= 1 );
    m_var2->setEnabled( num >= 2 );
    m_var3->setEnabled( num >= 3 );
    slotCalculate();
}


void Window::slotCalculate()
{
    QStringList varList;
    varList << m_var1->text();
    varList << m_var2->text();
    varList << m_var3->text();
    QString result = OperationManager::instance()->calculate(
            m_operation->currentText(), varList );
    m_result->setText( result );
}
