/****************************************************************************
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor,
** Boston, MA  02110-1301, USA.
**
** ---
** Copyright (C) 2006, Nicolas Arnaud-Cormos <nicolas@qtfr.org>
**
****************************************************************************/

#include <QtGui>
#include "textplugin.h"


QStringList TextPlugin::operationList()
{
    return QStringList() << tr("Inverse text")
            << tr("Replace");
}

bool TextPlugin::canCalculate( QString opName )
{
    QStringList opList;
    opList << tr("Inverse text")
            << tr("Replace");
    return opList.contains( opName );
}

int TextPlugin::numVariable( QString opName )
{
    if ( opName == tr("Inverse text") )
        return 1;
    return 3;
}

QString TextPlugin::calculate( QString opName, QStringList variableList )
{
    // Lecture de la première variable
    QString var1 = variableList[0];
    if ( var1.isEmpty() ) return tr("Syntax error");

    // Inversion du texte
    if ( opName == tr("Inverse text") ) {
        QString inverse;
        for ( int i=var1.count(); i!=0; --i ) {
            inverse += var1[i-1];
        }
        return inverse;
    }

    // Lecture des deux autres variables
    QString var2 = variableList[1];
    QString var3 = variableList[2];
    if ( var2.isEmpty() || var3.isEmpty() ) return tr("Syntax error");

    // Remplcament de texte
    if ( opName == tr("Replace") ) {
        var1.replace(var2, var3);
        return var1;
    }
    return QString();
}


Q_EXPORT_PLUGIN2(calcop_text, TextPlugin)
