/****************************************************************************
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor,
** Boston, MA  02110-1301, USA.
**
** ---
** Copyright (C) 2006, Nicolas Arnaud-Cormos <nicolas@qtfr.org>
**
****************************************************************************/

#ifndef OPERATIONINTERFACE_H
#define OPERATIONINTERFACE_H

class QString;
class QStringList;

/*!
 * \brief Interface pour les opérations
 * Cette interface sera utilisée pour les différents plugins. Elle permet de
 * gérer un ensemble d'opérations :
 *  - name : renvoie la liste des opérations gèrées,
 *  - canCalculate : indique si l'opération est prise en charge
 *  - numVariable : renvoie le nombre de variables utilisées pour chaque opération
 *  - calculate : renvoie le résultat pour une opération
 */
class OperationInterface
{
public:
    virtual ~OperationInterface() {}

    virtual QStringList operationList() = 0;
    virtual bool canCalculate( QString opName ) = 0;
    virtual int numVariable( QString opName ) = 0;
    virtual QString calculate( QString opName, QStringList variableList ) = 0;
};

Q_DECLARE_INTERFACE(OperationInterface,
                    "org.nikikko.CalcOp.OperationInterface/1.0")
#endif // OPERATIONINTERFACE_H
