/****************************************************************************
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor,
** Boston, MA  02110-1301, USA.
**
** ---
** Copyright (C) 2006, Nicolas Arnaud-Cormos <nicolas@qtfr.org>
**
****************************************************************************/

#include <QtGui>

#include "operationmanager.h"
#include "operationinterface.h"

OperationManager * OperationManager::m_instance = 0;


OperationManager::OperationManager()
{
    QDir pluginsDir = QDir(qApp->applicationDirPath());
    pluginsDir.cd("plugins");

    foreach (QString fileName, pluginsDir.entryList(QDir::Files)) {
        QPluginLoader loader(pluginsDir.absoluteFilePath(fileName));
        QObject *plugin = loader.instance();
        if (plugin) {
            OperationInterface * op = qobject_cast<OperationInterface *>(plugin);
            if (op) {
                m_operationList << op;
            }
        }
    }
}

OperationManager::~OperationManager()
{
    /* Pas besoin de supprimer les plugins en mémoire,
    ils sont supprimés automatiquement à la fin. */
}

QStringList OperationManager::operationList()
{
    QStringList list;
    foreach(OperationInterface * op, m_operationList) {
        list << op->operationList();
    }
    return list;
}

int OperationManager::numVariable( QString opName )
{
    OperationInterface * op = operation( opName );
    if (op) {
        return op->numVariable( opName );
    }
    return 0;
}

QString OperationManager::calculate( QString opName, QStringList variableList )
{
    OperationInterface * op = operation( opName );
    if (op) {
        return op->calculate( opName, variableList );
    }
    return QString();
}

OperationManager * OperationManager::instance()
{
    if (m_instance==0) {
        m_instance = new OperationManager();
    }
    return m_instance;
}

OperationInterface * OperationManager::operation( QString opName )
{
    foreach(OperationInterface * op, m_operationList) {
        if (op->canCalculate( opName )) {
            return op;
        }
    }
    return 0;
}
