/****************************************************************************
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor,
** Boston, MA  02110-1301, USA.
**
** ---
** Copyright (C) 2006, Nicolas Arnaud-Cormos <nicolas@qtfr.org>
**
****************************************************************************/

#include <QtGui>
#include "mathplugin.h"


QStringList MathPlugin::operationList()
{
    return QStringList() << tr("Addition")
            << tr("Subtraction")
            << tr("Multiplication")
            << tr("Division")
            << tr("Factorial");
}

bool MathPlugin::canCalculate( QString opName )
{
    QStringList opList;
    opList << tr("Addition")
            << tr("Subtraction")
            << tr("Multiplication")
            << tr("Division")
            << tr("Factorial");
    return opList.contains( opName );
}

int MathPlugin::numVariable( QString opName )
{
    if ( opName == tr("Factorial") )
        return 1;
    return 2;
}

QString MathPlugin::calculate( QString opName, QStringList variableList )
{
    // Lecture de la première variable
    bool ok;
    double var1 = variableList[0].toDouble(&ok);
    if ( !ok ) return tr("Syntax error");

    // Calcul factoriel
    if ( opName == tr("Factorial") ) {
        int fac = int(var1);
        int rFac = 1;
        for ( int i = 1; i <= fac; ++i ) {
            rFac *= i;
        }
        return QString::number(rFac);
    }

    // Lecture de la seconde variable
    double var2 = variableList[1].toDouble(&ok);
    if ( !ok ) return tr("Syntax error");

    // Calcul des différentes opérations
    if ( opName == tr("Addition") ) {
        return QString::number( var1+var2 );
    } else if ( opName == tr("Subtraction") ) {
        return QString::number( var1-var2 );
    } else if ( opName == tr("Multiplication") ) {
        return QString::number( var1*var2 );
    } else if ( opName == tr("Division") ) {
        return QString::number( var1/var2 );
    }
    return QString();
}


Q_EXPORT_PLUGIN2(calcop_math, MathPlugin)
